using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace BreadAndCheese {
    /// <summary>
    /// To jest gwny typ Twojej gry.
    /// </summary>
    public class BreadAndCheeseGame : Microsoft.Xna.Framework.Game {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat gry

        struct GameSpriteStruct {
            public Texture2D SpriteTexture;
            public Rectangle SpriteRectangle;
            public float X;
            public float Y;
            public float XSpeed;
            public float X;
            public float WidthFactor;
            public float TicksToCrossScreen;
        }

        GameSpriteStruct cheese;
        GameSpriteStruct bread;


        // Ustawienia ekranu
        float displayWidth;
        float displayHeight;
        float overScanPercentage = 10.0f;
        float minDisplayX;
        float maxDisplayX;
        float minDisplayY;
        float maxDisplayY;

        float getPercentage(float percentage, float inputValue) {
            return (inputValue * percentage) / 100;
        }

        private void setupScreen() {
            displayWidth = graphics.GraphicsDevice.Viewport.Width;
            displayHeight = graphics.GraphicsDevice.Viewport.Height;
            float xOverscanMargin = getPercentage(overScanPercentage, displayWidth) / 2.0f;
            float yOverscanMargin = getPercentage(overScanPercentage, displayHeight) / 2.0f;

            minDisplayX = xOverscanMargin;
            minDisplayY = yOverscanMargin;

            maxDisplayX = displayWidth - xOverscanMargin;
            maxDisplayY = displayHeight - yOverscanMargin;
        }

        void setupSprite(
                ref GameSpriteStruct sprite,
                float widthFactor,
                float ticksToCrossScreen,
                float initialX,
                float initialY) {
            sprite.WidthFactor = widthFactor;
            sprite.TicksToCrossScreen = ticksToCrossScreen;
            sprite.SpriteRectangle.Width = (int) ((displayWidth * widthFactor) + 0.5f);
            float aspectRatio =
                    (float) sprite.SpriteTexture.Width / sprite.SpriteTexture.Height;
            sprite.SpriteRectangle.Height =
                    (int) ((sprite.SpriteRectangle.Width / aspectRatio) + 0.5f);
            sprite.X = initialX;
            sprite.Y = initialY;
            sprite.XSpeed = displayWidth / ticksToCrossScreen;
            sprite.YSpeed = sprite.XSpeed;
        }

        void setupSprites() {
            // Szeroko sera jest rwna jednej dwudziestej (0,05) szerokoci ekranu; ser potrzebuje 200 taktw do pokonania caego ekranu.
            setupSprite(ref cheese, 0.05f, 200.0f, minDisplayX, minDisplayY);
            // Szeroko sera jest rwna trzem dwudziestym (0,15) szerokoci ekranu; chleb potrzebuje 120 taktw do pokonania caego ekranu.
            setupSprite(ref bread, 0.15f, 120.0f, displayWidth / 2, displayHeight / 2);
        }

        public BreadAndCheeseGame() {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Umoliwia ewentualn inicjalizacj przed uruchomieniem waciwej gry.
        /// W tym miejscu mona odnale wszystkie wymagane zasoby i zaadowa treci
        /// related content. Wywoanie metody base.Initialize spowoduje przeszukanie wszystkich komponentw
        /// i ich inicjalizacj.
        /// </summary>
        protected override void Initialize() {
            setupScreen();

            base.Initialize();
        }

        /// <summary>
        /// Metoda LoadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu adujcego tre.
        /// </summary>
        protected override void LoadContent() {
            // Tworzy nowy obiekt klasy SpriteBatch, ktrego mona uywa do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            cheese.SpriteTexture = Content.Load<Texture2D > ("Images/Cheese");
            bread.SpriteTexture = Content.Load<Texture2D > ("Images/Bread");

            setupSprites();
        }

        /// <summary>
        /// Metoda UnloadContent jest wywoywana tylko raz dla caej gry i jako taka jest waciwym miejscem
        /// dla kodu usuwajcego ca tre z pamici.
        /// </summary>
        protected override void UnloadContent() {
            // TODO: Naley usun ca tre, ktr nie zarzdza ContentManager.
        }

        /// <summary>
        /// Umoliwia grze wykonywanie logiki zwizanej z aktualizacj wiata gry,
        /// sprawdzaniem kolizji, pobieraniem danych wejciowych czy odtwarzaniem dwikw.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Update(GameTime gameTime) {
            GamePadState gamePad1 = GamePad.GetState(PlayerIndex.One);
            // Pozwala opuci gr
            if (gamePad1.Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // Ruch chleba

            bread.X = bread.X + (bread.XSpeed * gamePad1.ThumbSticks.Left.X);
            bread.Y = bread.Y - (bread.YSpeed * gamePad1.ThumbSticks.Left.Y);
            bread.SpriteRectangle.X = (int) bread.X;
            bread.SpriteRectangle.Y = (int) bread.Y;

            // Ruch sprajtu sera

            cheese.X = cheese.X + cheese.XSpeed;
            cheese.Y = cheese.Y + cheese.YSpeed;
            cheese.SpriteRectangle.X = (int) (cheese.X + 0.5f);
            cheese.SpriteRectangle.Y = (int) (cheese.Y + 0.5f);

            if (cheese.X + cheese.SpriteRectangle.Width >= maxDisplayX) {
                cheese.XSpeed = Math.Abs(cheese.XSpeed) * -1;
            }

            if (cheese.X <= minDisplayX) {
                cheese.XSpeed = Math.Abs(cheese.XSpeed);
            }

            if (cheese.Y + cheese.SpriteRectangle.Height >= maxDisplayY) {
                cheese.YSpeed = Math.Abs(cheese.YSpeed) * -1;
            }

            if (cheese.Y <= minDisplayY) {
                cheese.YSpeed = Math.Abs(cheese.YSpeed);
            }

            // Ser odbija si od paki.

            if (cheese.SpriteRectangle.Intersects(bread.SpriteRectangle)) {
                // mamy kolizj
                cheese.YSpeed = cheese.YSpeed * -1;
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// Ta metoda jest wywoywana w momencie, w ktrym gra musi narysowa swj wiat.
        /// </summary>
        /// <param name="gameTime">Udostpnia wartoci reprezentujce biecy czas.</param>
        protected override void Draw(GameTime gameTime) {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();

            spriteBatch.Draw(cheese.SpriteTexture, cheese.SpriteRectangle, Color.White);
            spriteBatch.Draw(bread.SpriteTexture, bread.SpriteRectangle, Color.White);

            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
